/*
 * Decompiled with CFR 0.152.
 */
package com.elp.apielp.Controller;

import com.elp.apielp.DAO.Horoscope;
import com.elp.apielp.DAO.Politique;
import com.elp.apielp.DAO.TopInfo;
import com.elp.apielp.Service.HoroscopeScrapingService;
import java.io.IOException;
import java.util.Vector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/horoscope"})
public class ScrapController {
    @Autowired
    private HoroscopeScrapingService service;

    @GetMapping(value={"/{month}/{day}"})
    public Horoscope getHoroscope(@PathVariable int month, @PathVariable int day) {
        return this.service.getHoroscopeForSign(day, month);
    }

    @GetMapping(value={"/orangeInfo"})
    public Vector<TopInfo> getOrangeInfo() {
        return this.service.getInfoOrange();
    }

    @GetMapping(value={"/orange/politique"})
    public Vector<Politique> getAllPolitique() throws IOException {
        return this.service.getNews("https://actu.orange.mg/rubrique/madagascar/politique/");
    }

    @GetMapping(value={"/orange/societe"})
    public Vector<Politique> getSociete() throws IOException {
        return this.service.getNews("https://actu.orange.mg/rubrique/madagascar/societe/");
    }

    @GetMapping(value={"/orange/economie"})
    public Vector<Politique> getEconomie() throws IOException {
        return this.service.getNews("https://actu.orange.mg/rubrique/madagascar/economie/");
    }

    @GetMapping(value={"/orange/culture"})
    public Vector<Politique> getCulture() throws IOException {
        return this.service.getNews("https://actu.orange.mg/rubrique/madagascar/culture/");
    }

    @GetMapping(value={"/orange/sport"})
    public Vector<Politique> getSport() throws IOException {
        return this.service.getNews("https://actu.orange.mg/rubrique/madagascar/sport/");
    }
}

