/*
 * Decompiled with CFR 0.152.
 */
package com.elp.apielp.Model.Notification;

import com.elp.apielp.Model.Employe;
import com.elp.apielp.Model.Notification.TitreNotif;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.time.LocalDateTime;

@Entity
@Table(name="notification")
public class Notification {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="idNotification")
    private Long id;
    @Column(name="dateInsert", nullable=false)
    private LocalDateTime dateInsert = LocalDateTime.now();
    @Column(name="dateVue")
    private LocalDateTime dateVue;
    @ManyToOne
    @JoinColumn(name="empResp", referencedColumnName="idEmp")
    private Employe empResp;
    @ManyToOne
    @JoinColumn(name="idTitreMes", referencedColumnName="idTitreNotif")
    private TitreNotif titreNotif;
    @Column(name="messageFinal", length=300, nullable=false)
    private String messageFinal;
    @Column
    private long idObject;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LocalDateTime getDateInsert() {
        return this.dateInsert;
    }

    public void setDateInsert(LocalDateTime dateInsert) {
        this.dateInsert = dateInsert;
    }

    public LocalDateTime getDateVue() {
        return this.dateVue;
    }

    public void setDateVue(LocalDateTime dateVue) {
        this.dateVue = dateVue;
    }

    public Employe getEmpResp() {
        return this.empResp;
    }

    public void setEmpResp(Employe empResp) {
        this.empResp = empResp;
    }

    public TitreNotif getTitreNotif() {
        return this.titreNotif;
    }

    public void setTitreNotif(TitreNotif titreNotif) {
        this.titreNotif = titreNotif;
    }

    public String getMessageFinal() {
        return this.messageFinal;
    }

    public void setMessageFinal(String ... value) {
        String mes = this.titreNotif.getMessageFormat();
        this.messageFinal = mes.formatted(value);
    }

    public long getIdObject() {
        return this.idObject;
    }

    public void setIdObject(long idObject) {
        this.idObject = idObject;
    }

    public Notification() {
    }

    public Notification(Long id, LocalDateTime dateInsert, LocalDateTime dateVue, Employe empResp, TitreNotif titreNotif, String messageFinal, long idObject) {
        this.id = id;
        this.dateInsert = dateInsert;
        this.dateVue = dateVue;
        this.empResp = empResp;
        this.titreNotif = titreNotif;
        this.messageFinal = messageFinal;
        this.idObject = idObject;
    }
}

