/*
 * Decompiled with CFR 0.152.
 */
package com.elp.apielp.Model;

import com.elp.apielp.Model.Employe;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;

@Entity
@Table(name="renduFile")
public class RenduFile {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    private String reference;
    @ElementCollection
    private List<String> fileNames;
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idEmploye")
    private Employe sender;
    @Column
    private LocalDate date;

    @PrePersist
    protected void onCreate() {
        if (this.date == null) {
            ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneId.of("Indian/Antananarivo"));
            this.date = zonedDateTime.toLocalDate();
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public List<String> getFileNames() {
        return this.fileNames;
    }

    public void setFileNames(List<String> fileNames) {
        this.fileNames = fileNames;
    }

    public Employe getSender() {
        return this.sender;
    }

    public void setSender(Employe sender) {
        this.sender = sender;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public RenduFile(String reference, List<String> fileNames, Employe sender) {
        this.reference = reference;
        this.fileNames = fileNames;
        this.sender = sender;
        ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneId.of("Indian/Antananarivo"));
        this.date = zonedDateTime.toLocalDate();
    }

    public RenduFile() {
    }
}

