/*
 * Decompiled with CFR 0.152.
 */
package com.elp.apielp.Service;

import com.elp.apielp.DAO.CongeDao;
import com.elp.apielp.DAO.InfoConge;
import com.elp.apielp.Model.Conge;
import com.elp.apielp.Model.InfoRh;
import com.elp.apielp.Repository.CongeRepository;
import com.elp.apielp.Repository.InfoRhRepository;
import com.elp.apielp.Repository.UnknowDAO;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CongeService {
    @Autowired
    private CongeRepository congeRepository;
    @Autowired
    private InfoRhRepository infoRhRepository;
    @Autowired
    private UnknowDAO info;

    @Transactional
    public Conge create(CongeDao input) throws Exception {
        InfoRh stat = this.infoRhRepository.getByEmploye_IdEmp(input.getIdEmp().getIdEmp().longValue());
        int nbAnne = CongeService.calculerNombreAnnees((LocalDate)stat.getDateEntre().toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), (LocalDate)LocalDate.now());
        if (nbAnne < 1) {
            throw new Exception("L'employ\u00e9 a travaill\u00e9 moins d'un an.");
        }
        if (input.nbConge() > this.nbCongeRestant(nbAnne, input.getIdEmp().getIdEmp().longValue())) {
            throw new Exception("Vous n'avez pas ce droit de cong\u00e9.");
        }
        Conge conge = new Conge();
        conge.setCause(input.getCause());
        conge.setEmploye(input.getIdEmp());
        conge.setDateDebut(input.getDateDebut());
        conge.setDateFin(input.getDateFin());
        conge.setMatinDebut(input.isMatinDebut());
        conge.setMatinFin(input.isMatinFin());
        return (Conge)this.congeRepository.save((Object)conge);
    }

    @Transactional(readOnly=true)
    public List<Conge> getAllConge(long idEmp) {
        return this.congeRepository.findByEmploye_IdEmp_OrderByDateDemandeDesc(idEmp);
    }

    public double nbCongeRestant(int totalAge, long idEmp) {
        int total = 30 * totalAge;
        double congePrise = this.congeRepository.getSumConge(idEmp);
        return (double)total - congePrise;
    }

    public static int calculerNombreAnnees(LocalDate dateDebut, LocalDate dateFin) {
        if (dateDebut == null || dateFin == null) {
            throw new IllegalArgumentException("Les dates ne doivent pas \u00eatre nulles");
        }
        Period periode = Period.between(dateDebut, dateFin);
        return periode.getYears();
    }

    public double getSolde(long idEmp) {
        InfoRh stat = this.infoRhRepository.getByEmploye_IdEmp(idEmp);
        int nbAnne = CongeService.calculerNombreAnnees((LocalDate)stat.getDateEntre().toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), (LocalDate)LocalDate.now());
        return this.nbCongeRestant(nbAnne, idEmp);
    }

    public double[] getPerMonth(int an, long idEmp) {
        return this.congeRepository.getNbCongePerMonth(an, idEmp);
    }

    public List<InfoConge> getInfo(int an, int mois, long idEmp) {
        return this.info.findSlashDate(mois, an, idEmp);
    }

    @Transactional
    public void delete(long idConge) {
        this.congeRepository.deleteById((Object)idConge);
    }

    public List<Conge> getByStatutNonValide() {
        return this.congeRepository.findByStatut(Conge.EtatConge.ENCOURS);
    }

    public void modif(Conge conge) {
        this.congeRepository.save((Object)conge);
    }
}

