/*
 * Decompiled with CFR 0.152.
 */
package com.elp.apielp.Service;

import com.elp.apielp.Model.Employe;
import com.elp.apielp.Model.EtatEmployer;
import com.elp.apielp.Model.Notification.Notification;
import com.elp.apielp.Model.Notification.TuteurNotif;
import com.elp.apielp.Repository.EmployeRepository;
import com.elp.apielp.Repository.EtatEmployeRepository;
import com.elp.apielp.Repository.Notif.NotificationRepository;
import com.elp.apielp.Repository.Notif.TuteurNotifRepository;
import com.elp.apielp.WP.Config.WebSocketSessionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class NotificationService {
    @Autowired
    private TuteurNotifRepository tuteurNotifRepository;
    @Autowired
    private NotificationRepository notificationRepository;
    @Autowired
    private SimpMessagingTemplate sendMessage;
    @Autowired
    private EmployeRepository employeRepository;
    @Autowired
    private WebSocketSessionManager sessionManager;
    @Autowired
    private EtatEmployeRepository etatEmployeRepository;

    @Async
    public void save(Notification notification, int[] tuteur) {
        this.notificationRepository.save((Object)notification);
        EtatEmployer etatEmployer = this.etatEmployeRepository.employeIdEmp(notification.getEmpResp().getIdEmp().longValue());
        for (int k : tuteur) {
            String sendList;
            TuteurNotif e = new TuteurNotif();
            e.setNotification(notification);
            e.setEmploye((Employe)this.employeRepository.getReferenceById((Object)k));
            e.setOpen(false);
            e.setDeleted(false);
            this.tuteurNotifRepository.save((Object)e);
            String id = "/notif/all/" + k;
            if (this.sessionManager.isUrlActive(id)) {
                System.out.println("Message sent...");
                this.sendMessage.convertAndSend((Object)id, (Object)this.tuteurNotifRepository.getTuteurNotifByIdTuteurNotif(e.getIdTuteurNotif().longValue()));
            }
            if (!this.sessionManager.isUrlActive(sendList = "/notif/validerSalarier/" + k)) continue;
            System.out.println("idEmp..." + notification.getEmpResp().getIdEmp());
            this.sendMessage.convertAndSend((Object)sendList, (Object)etatEmployer);
        }
    }

    @Async
    public void sendNotif(String id, Object sn) {
        if (this.sessionManager.isUrlActive(id)) {
            this.sendMessage.convertAndSend((Object)id, sn);
        }
    }
}

