/*
 * Decompiled with CFR 0.152.
 */
package com.elp.apielp.Service;

import com.elp.apielp.DAO.RenduDAO;
import com.elp.apielp.Model.Employe;
import com.elp.apielp.Model.Rendu;
import com.elp.apielp.Repository.DaoRenduRepository;
import com.elp.apielp.Repository.EmployeRepository;
import com.elp.apielp.Repository.RenduRepository;
import jakarta.transaction.Transactional;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RenduService {
    @Autowired
    private RenduRepository renduRepository;
    @Autowired
    private EmployeRepository emp;
    @Autowired
    private DaoRenduRepository dao;

    public RenduDAO insertRendu(RenduDAO rendu) {
        Rendu t = new Rendu();
        t.setDateDebut(new Date());
        t.setComment(rendu.getComment());
        t.setStatut(Rendu.Statut.fromValue((int)rendu.getStatut()));
        t.setTache(rendu.getTache());
        t.setEmploye((Employe)this.emp.getById((Object)rendu.getEmploye()));
        Rendu j = (Rendu)this.renduRepository.save((Object)t);
        return new RenduDAO(j.getIdRendu(), rendu.getEmploye(), j.getDateDebut(), rendu.getTache(), rendu.getComment(), rendu.getStatut());
    }

    public List<RenduDAO> getRenduDAO(Date debut, Date fin, long idEmp) {
        return this.dao.getWeekTask(idEmp, fin, debut);
    }

    @Transactional
    public void deleteRendu(long id) {
        this.renduRepository.deleteById((Object)id);
    }

    public void modif(RenduDAO up) {
        Rendu t = (Rendu)this.renduRepository.getReferenceById((Object)up.getIdRendu());
        t.setStatut(Rendu.Statut.fromValue((int)up.getStatut()));
        t.setTache(up.getTache());
        t.setComment(up.getComment());
        this.renduRepository.save((Object)t);
    }
}

