/*
 * Decompiled with CFR 0.152.
 */
package com.elp.apielp;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
public class JwtUtil {
    @Value(value="${jwt.secret}")
    private String secret;

    public String generateToken(UserDetails user, long idEmp) {
        Date now = new Date();
        Date expirationDate = new Date(now.getTime() + 36000000L);
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("sub", user.getUsername());
        claims.put("id", idEmp);
        return Jwts.builder().setClaims(claims).setIssuedAt(now).setExpiration(expirationDate).signWith(SignatureAlgorithm.HS512, this.secret).compact();
    }

    public String extractUsername(String token) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(this.secret).parseClaimsJws(token).getBody();
        return (String)claims.get("sub", String.class);
    }

    public long getIdEmp(String token) {
        try {
            Claims claims = (Claims)Jwts.parser().setSigningKey(this.secret).parseClaimsJws(token).getBody();
            return (Long)claims.get("id", Long.class);
        }
        catch (SignatureException e) {
            throw new RuntimeException("Invalid token");
        }
    }

    public Boolean validateToken(String token, UserDetails userDetails) {
        String username = this.extractUsername(token);
        return username.equals(userDetails.getUsername()) && this.isTokenExpired(token) == false;
    }

    private Boolean isTokenExpired(String token) {
        Date expiration = ((Claims)Jwts.parser().setSigningKey(this.secret).parseClaimsJws(token).getBody()).getExpiration();
        return expiration.before(new Date());
    }
}

