/*
 * Decompiled with CFR 0.152.
 */
package com.elp.apielp.Repository;

import com.elp.apielp.Model.Conge;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface CongeRepository
extends JpaRepository<Conge, Long> {
    @Query(value="    SELECT COALESCE(SUM(GREATEST(\n            (DATEDIFF(DATE(dateFin), DATE(dateDebut)) +\n             CASE\n                 WHEN ismatindebut AND ismatinfin THEN -0.5\n                 WHEN ismatindebut AND NOT ismatinfin THEN 0\n                 WHEN NOT ismatindebut AND NOT ismatinfin THEN -0.5\n                 ELSE 0\n                 END),\n            0\n        )), 0)\n    FROM conge\n    WHERE idemp = :idEmp\n      AND statut IN ('ENCOURS', 'ACCEPTER')\n", nativeQuery=true)
    public double getSumConge(@Param(value="idEmp") long var1);

    public List<Conge> findByEmploye_IdEmp_OrderByDateDemandeDesc(long var1);

    @Query(value="WITH RECURSIVE allMonth AS (\n    SELECT 1 AS mois\n    UNION ALL\n    SELECT mois + 1\n    FROM allMonth\n    WHERE mois < 12\n), totalConge AS (\n    SELECT\n        gs.mois AS month,\n        COALESCE(\n                SUM(\n                        GREATEST(\n                                    (getDateFin(dateFin, gs.mois, :an) - getDateDebut(dateDebut, gs.mois, :an)) +\n                                    getExtraTime(\n                                            getDateDebut(dateDebut, gs.mois, :an),\n                                            getDateFin(dateFin, gs.mois, :an),\n                                            dateDebut, dateFin, ismatindebut, ismatinfin\n                                        ),\n                                    0\n                            )\n                    ),\n                0\n            ) AS total\n    FROM conge\n             RIGHT JOIN allMonth AS gs ON TRUE\n    WHERE\n        (YEAR(dateDebut) = :an OR YEAR(dateFin) = :an)\n      AND idemp = :idEmp\n      AND statut = 'ACCEPTER'\n      AND (\n                MONTH(dateDebut) = gs.mois OR MONTH(dateFin) = gs.mois\n        )\n    GROUP BY gs.mois\n)\nSELECT COALESCE(total, 0) AS total\nFROM allMonth\n         LEFT JOIN totalConge ON allMonth.mois = totalConge.month\nORDER BY allMonth.mois\n", nativeQuery=true)
    public double[] getNbCongePerMonth(@Param(value="an") int var1, @Param(value="idEmp") long var2);

    public List<Conge> findByStatut(Conge.EtatConge var1);
}

