/*
 * Decompiled with CFR 0.152.
 */
package com.elp.apielp.Service;

import com.elp.apielp.DAO.Horoscope;
import com.elp.apielp.DAO.Politique;
import com.elp.apielp.DAO.TopInfo;
import com.elp.apielp.Model.AstrologicalSign;
import com.elp.apielp.Repository.AstrologicalSignRepository;
import java.io.IOException;
import java.util.Objects;
import java.util.Vector;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HoroscopeScrapingService {
    @Autowired
    private AstrologicalSignRepository repository;

    public Horoscope getHoroscopeForSign(int day, int mont) {
        AstrologicalSign sign = this.repository.getSign(mont, day);
        if (sign != null) {
            try {
                Document document = Jsoup.connect((String)sign.getLink()).get();
                Element humeurElement = document.selectFirst("div.horo_content_c p");
                Element climatAstralElement = document.selectFirst("div#content_intro p");
                String humeur = humeurElement != null ? humeurElement.text() : "Humeur non trouv\u00e9e";
                String climat = climatAstralElement != null ? climatAstralElement.text() : "Climat astral non trouv\u00e9";
                return new Horoscope(climat, humeur, sign.getSignName());
            }
            catch (IOException e) {
                e.printStackTrace();
                return new Horoscope("", "", sign.getSignName());
            }
        }
        return null;
    }

    public Vector<TopInfo> getInfoOrange() {
        try {
            Document document = Jsoup.connect((String)"https://actu.orange.mg/").get();
            Vector<TopInfo> allTop = new Vector<TopInfo>();
            Elements articles = document.select("article.carousel-article");
            for (Element article : articles) {
                String imageUrl = article.select("figure.article-background").attr("data-background");
                Elements description = article.select("div.article-title a");
                String desc = description.text();
                String link = description.attr("href");
                String date = article.select("div.article-detail").text();
                allTop.add(new TopInfo(imageUrl, date, desc, link));
            }
            return allTop;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new Vector<TopInfo>();
        }
    }

    public Vector<Politique> getNews(String url) throws IOException {
        Vector<Politique> politiques = new Vector<Politique>();
        Document document = Jsoup.connect((String)url).get();
        Elements articles = document.select("article.oma-li-article");
        for (Element e : articles) {
            Elements image = e.select("figure.article-image a");
            String getLinkImage = e.select("figure.article-image a img").attr("src");
            String demiTitre = Objects.requireNonNull(e.select("div.article-meta h2")).text();
            String demiContent = e.select("div.article-content p").text();
            String date = Objects.requireNonNull(e.select("footer")).text();
            String link = image.attr("href");
            Document getTiltle = Jsoup.connect((String)link).get();
            String title = getTiltle.title();
            String desc = getTiltle.select("div.entry-content").html();
            politiques.add(new Politique(getLinkImage, date, demiTitre, demiContent, title, desc));
        }
        return politiques;
    }
}

