/*
 * Decompiled with CFR 0.152.
 */
package com.elp.apielp.WP.Config;

import com.elp.apielp.WP.SessionWP;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.event.EventListener;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.messaging.SessionDisconnectEvent;
import org.springframework.web.socket.messaging.SessionSubscribeEvent;
import org.springframework.web.socket.messaging.SessionUnsubscribeEvent;

@Component
public class WebSocketSessionManager {
    private final List<SessionWP> sessionManager = new ArrayList();

    @EventListener
    public void handleSessionSubscribe(SessionSubscribeEvent event) {
        StompHeaderAccessor headerAccessor = (StompHeaderAccessor)MessageHeaderAccessor.getAccessor((Message)event.getMessage(), StompHeaderAccessor.class);
        if (headerAccessor != null) {
            String sessionId = headerAccessor.getSessionId();
            String destination = headerAccessor.getDestination();
            if (destination != null) {
                SessionWP.add((List)this.sessionManager, (String)sessionId, (String)headerAccessor.getSubscriptionId(), (String)destination);
            }
        }
    }

    @EventListener
    public void handleSessionUnsubscribe(SessionUnsubscribeEvent event) {
        StompHeaderAccessor headerAccessor = (StompHeaderAccessor)MessageHeaderAccessor.getAccessor((Message)event.getMessage(), StompHeaderAccessor.class);
        if (headerAccessor != null) {
            String sessionId = headerAccessor.getSessionId();
            String id = headerAccessor.getSubscriptionId();
            SessionWP.deleteSubscribeSession((String)sessionId, (String)id, (List)this.sessionManager);
        }
    }

    @EventListener
    public void handleSessionDisconnect(SessionDisconnectEvent event) {
        String sessionId = event.getSessionId();
        boolean removed = this.sessionManager.removeIf(session -> session.getSession().equalsIgnoreCase(sessionId));
        if (removed) {
            System.out.println("Session disconnected: " + sessionId);
        } else {
            System.out.println("No session found to disconnect for sessionId: " + sessionId);
        }
    }

    public boolean isUrlActive(String url) {
        return this.sessionManager.stream().anyMatch(session -> session.isUrlActive(url));
    }
}

